#include <coleco.h>

byte pop_sound[]=
{
    0, /* melodic */
    0x60,1,4, /* volume swept +4 each 1 cycle */
    0x81,0x1d, /* G sound */
    0x90, /* attenuation =0 */
    4, /* note length =4 */
    0,0,0 /* end of sound */
};

void pop()
{
    start_sound(pop_sound,2);
}
/* Note: Sound lenght = 4 */

byte pop2_sound[]=
{
    0, /* melodic */
    0x60,1,3, /* volume swept +3 each 1 cycle */
    0x80,0xd5, /* C sound */
    0x90, /* attenuation =0 */
    4, /* note length =4 */
    0,0,0 /* end of sound */
};

void pop2()
{
    start_sound(pop2_sound,2);
}
/* Note: Sound lenght = 4 */

byte shoot_sound[]=
{
    1, /* noise */
    0x60,2,1, /* volume swept +1 each 2 cycles */
    0xe4, /* noisy sound */
    0xf0, /* attenuation =0 */
    30, /* note length =8 */
    0,0,0 /* end of sound */
};

void shoot()
{
    start_sound(shoot_sound,2);
}
/* Note: Noise lenght = 30 */

byte theme_sound[]=
{
     0, /* melodic */
     0x80,0x83,0x98,7,0x9f,1,    /* G sound, 50% attenuation, held for 3*/
     0x80,0xa0,0x98,7,0x9f,1,   /* F, quarter */
     0x80,0xa9,0x98,7,0x9f,1,  /* E, quarter */
     0x80,0xd5,0x98,15,0x9f,1,  /* C, half */
     0x80,0xbe,0x98,7,0x9f,1,  /* D, quarter */
     0x80,0xa9,0x98,15,0x9f,1,  /* E, half */
     0x80,0x83,0x98,7,0x9f,1,    /* G sound, 50% attenuation, quarter*/
     0x80,0xa0,0x98,7,0x9f,1,  /* F, quarter */
     0x80,0xa9,0x98,7,0x9f,1,  /* E, quarter */
     0x80,0xd5,0x98,15,0x9f,1,  /* C, half */
     0x80,0xbe,0x98,7,0x9f,1,  /* D, quarter */
     0x80,0xa9,0x98,15,0x9f,1,  /* E, half */
     0x80,0x83,0x98,7,0x9f,1,    /* G sound, 50% attenuation, quarter*/
     0x80,0xa0,0x98,7,0x9f,1,  /* F, quarter */
     0x80,0xa9,0x98,7,0x9f,1,  /* E, quarter */
     0x80,0xd5,0x98,7,0x9f,1,  /* C, quarter */
     0x80,0xbe,0x98,7,0x9f,1,  /* D, quarter */
     0x80,0xa9,0x98,15,0x9f,1,  /* E, half */
     0x80,0xbe,0x98,15,0x9f,1,  /* D, half */
     0x80,0xd5,0x98,7,0x9f,1,  /* C, quarter */
     0x80,0xbe,0x98,7,0x9f,1,  /* D, quarter */
     0x80,0xa9,0x98,7,0x9f,1,  /* E, quarter */
     0x80,0x7f,0x98,7,0x9f,1,  /* A, quarter */
     0x80,0x83,0x98,7,0x9f,1,  /* G sound, quarter*/
     0x80,0x7f,0x98,7,0x9f,1,  /* A, quarter */
     0x80,0x83,0x98,7,0x9f,1,  /* G sound, quarter*/
     0x80,0xbe,0x98,15,0x9f,1,  /* D, half */
     0x9f,6,                    /* rest quarter */
     0x80,0x7f,0x98,7,0x9f,1,  /* A, quarter */
     0x80,0x83,0x98,7,0x9f,1,  /* G sound, quarter*/
     0x80,0x7f,0x98,7,0x9f,1,  /* A, quarter */
     0x80,0x83,0x98,7,0x9f,1,  /* G sound, quarter*/
     0x80,0xd5,0x98,15,0x9f,1,  /* C, half */
     0x9f,6,                    /* rest quarter */
     0x80,0x83,0x98,7,0x9f,1,    /* G sound, 50% attenuation, quarter*/
     0x80,0xa0,0x98,7,0x9f,1,  /* F, quarter */
     0x80,0xa9,0x98,7,0x9f,1,  /* E, quarter */
     0x80,0xd5,0x98,7,0x9f,1,  /* C, quarter */
     0x80,0xbe,0x98,7,0x9f,1,  /* D, quarter */
     0x80,0xd5,0x98,15,0x9f,1,  /* C, quarter */
     0x9f,6,       /* rest quarter */
     0,0,0
};

void theme(int level)
{
    start_sound(theme_sound,3);
}
