#include <coleco.h>
#include <getput1.h>

extern byte PATTERNRLE[];
extern byte COLORRLE[];
extern byte NAMERLE[];
extern byte SPATTERNRLE[];
extern int SPRITESINITSIZE;
extern byte SPRITESINIT[];
extern void theme(int level);
extern void pop();
extern void pop2();
extern void shoot();

int game_speed;
int score;
int hiscore;
char level_active;
char level;

struct IngredInfo {
    char *singular;
    char *plural;
    char ch;
} ingredient_name[]={
    {"empty",          "empty",0},
    {"carrot",         "carrots",130},
    {"head of lettuce","heads of lettuce",131},
    {"stalk of celery","stalks of celery",132},
    {"tomato",         "tomatoes",133},
    {"cucumber",       "cucumbers",134},
    {"green pepper",   "green peppers",135},
    {"potato",         "potatoes",142},
    {"onion",          "onions",143},
    {"red onion",      "red onions",158},
    {"clump of chives","clumps of chives",170},
    {"radish",         "radishes",169},
    {"black olive",    "black olives",159},
    {"clove of garlic","cloves of garlic", 171},
    {"clump of parsley","clumps of parsely",170},
    {"stalk of oregano","stalks of oregano", 170},
    {"lemon",           "lemons",172}
};

enum Ingred { EMPTY,CARROT,LETTUCE,CELERY,TOMATO,CUCUMBER,GRPEPPER,POTATO,
ONION,RONION,CHIVES,RADISH,BLOLIVE,GARLIC,PARSLEY,ORAGANO,LEMON};

typedef struct {
    enum Ingred ingred;
    int points;
} Ingredient;    

typedef struct {
    char *name;
    Ingredient ingredient[4];    /* List of required ingredients for salad. */
} Salad;

Salad salad[]={
  {  "Garden Salad",{{LETTUCE,1},{TOMATO,1},{CARROT,2},{CELERY,3}}},  
  {  "Potato Salad",{{POTATO,4},{PARSLEY,1},{RADISH,1},{ONION,1}}},  
  {  "Caeser Salad",{{LETTUCE,1},{PARSLEY,1},{LEMON,1},{RONION,1}}},  
  {  "Greek Salad",{{LETTUCE,1},{TOMATO,1},{BLOLIVE,8},{ONION,1}}},  
  {  "Village Salad",{{CUCUMBER,2},{TOMATO,3},{RONION,1},{BLOLIVE,8}}},  
  {  "Green Salad",{{LETTUCE,1},{CELERY,3},{CUCUMBER,1},{GRPEPPER,1}}},
};    

typedef struct {
    char id; /* bunny id (=0 if P1; =1 if P2) */
    byte x,y;
    char dx,dy;
    byte dir;    /* direction */
    char delay;
    char frame;
    char hold[2];	/* What the actor is holding in its paws */
    char has[4];	/* What the actor has in its basket */
    char need[4];	/* The closeness to the win condition */
    unsigned score;
    char isNPC;	/* Is played by real player or not */
    char state;		/* for NPC, what it thinking */
    byte targetx,targety;	/* Where the NPC is walking to */
    char target;		/* The ingredient that the actor is after */
} Bunny;

Bunny bunny[2];

/* init_graphics function */
void init_graphics()
{
    screen_mode_2_text();
    load_patternrle(PATTERNRLE);
    load_colorrle(COLORRLE);
    upload_default_ascii(BOLD);
    fill_color(32,0xf0,96);
	load_spatternrle(SPATTERNRLE);
	sprites_16x16();
	
	memcpy(sprites,SPRITESINIT,SPRITESINITSIZE);
}

void show_needs(Bunny *actor)
{
     byte i,x;
     x = 9+actor->id*13;
     for (i=0;i<4;i++)
     {
         put_char(x,3,actor->need[i]);
         x +=2 ;
     }
}

void show_has(Bunny *actor)
{
     byte i,x;
     x = 9+actor->id*13;
     for (i=0;i<4;i++)
     {
         put_char(x,2,actor->has[i]);
         x +=2; 
     }
}

void show_hold(Bunny *actor)
{
     byte i,x;
     x = 9+actor->id*13;
     for (i=0;i<2;i++)
     {
         put_char(x,1,actor->hold[i]);
         x +=2; 
     }
}

void refresh_status(Bunny *actor)
{
     show_needs(actor);
     show_has(actor);
     show_hold(actor);
     print_at(9+actor->id*13,0,str(actor->score));
}

void initbunny(Bunny *actor)
{
    actor->y = 102;
    actor->x = (128-16) + actor->id*32;
    actor->delay = 0;
    actor->frame = 0;
    actor->dir = 15;
    actor->state = 1;
    actor->target=0;
    actor->need[0]=ingredient_name[salad[level].ingredient[0].ingred].ch;
    actor->need[1]=ingredient_name[salad[level].ingredient[1].ingred].ch;
    actor->need[2]=ingredient_name[salad[level].ingredient[2].ingred].ch;
    actor->need[3]=ingredient_name[salad[level].ingredient[3].ingred].ch;
    actor->hold[0]=0;
    actor->hold[1]=0;
    actor->has[0]=0;
    actor->has[1]=0;
    actor->has[2]=0;
    actor->has[3]=0;
}
 
void initialize_level(int lev)
{
    level_active=1;
    level=lev;
    bunny[0].id = 0;
    bunny[1].id = 1;
    initbunny(&bunny[0]);
    initbunny(&bunny[1]);
	load_namerle(NAMERLE);
	refresh_status(&bunny[0]);
	refresh_status(&bunny[1]);
}

void game_delay()
{
    enable_nmi();
    delay(game_speed);
    disable_nmi();
}

void set_bunny_dir(Bunny *actor)
{
    char dir = actor->dir;
    /* Set first frame of animation. */
    switch(dir) {
    case RIGHT:
    case (RIGHT|UP):
    case (RIGHT|DOWN):
        actor->frame=0;
        break;
    case LEFT:
    case (LEFT|UP):
    case (LEFT|DOWN):
        actor->frame=4;
        break;
    case UP:
        actor->frame=8;
        break;
    case DOWN:
        actor->frame=12;
        break;
    default:
        actor->frame=0;
    }
    actor->dir=dir;
}    

void move_bunny(Bunny *actor)
{
    char dist=actor->isNPC?2:4;
    /* Move bunny in dir */
    if(actor->dir&UP) actor->y-=dist;
    if(actor->dir&DOWN) actor->y+=dist;
    if(actor->dir&LEFT) actor->x-=dist;
    if(actor->dir&RIGHT) actor->x+=dist;
}

char choose_direction(byte fromx,byte fromy,byte tox,byte toy)
{
    if(fromx/8==tox/8 && fromy/8==toy/8) return 0;
    if(fromx==tox) return fromy<toy?DOWN:UP;
    if(fromy==toy) return fromx<tox?LEFT:RIGHT;
    /* Now do diagonal choices */
    if(fromx<tox) {
        return fromy<toy?RIGHT|DOWN:RIGHT|UP;
    }
    /* fromx>tox */
    return fromy<toy?LEFT|DOWN:LEFT|UP;
}

/* state 2 and 4 traveling function */
void walk_towards(Bunny *actor)
{
    if(actor->target>0) {
        if(get_char(actor->targetx/8,actor->targety/8)!=actor->target) {
            actor->state=1;	/* The thing we're targeting is gone, so state 1 */
            return;
        }
    }
    actor->dir=choose_direction(actor->x,actor->y,actor->targetx,actor->targety);
    
    if (actor->dir==0) actor->state = actor->state==2?3:5;
}

/* state 3 standing at the wanted ingredient */
void standing_at_ingredient(Bunny *actor)
{

     byte x,y;
     char target_c;
     char c;

     x = actor->x/8;
     y = actor->y/8;
     target_c = actor->target;
     c = get_char(x,y);

     refresh_status(actor);
    
    if(c!=target_c) {
        actor->state=1; /* Wild goose chase, so make a new plan */
        return;
    }
    
    if(actor->hold[0]==0) {
        actor->hold[0]=c;
    } else if(actor->hold[1]==0) {
        actor->hold[1]=c;
    }
    put_char(x,y,0x8c);
    /* Use both paws? */
    if(actor->hold[0]!=0 && actor->hold[1]!=0) {
        actor->target = 0;
        actor->targety = 15*8;
        if(actor->id==0) {
            actor->targetx = 3*8;
        } else {
            actor->targetx = 29*8;
        }
        actor->state=4;
    } else {
        actor->state=1;
    }
}

/* Bunny on basket space */
int on_basket(Bunny *actor)
{
    if(actor->y<15*8) return 0;
    if(actor->y>17*8) return 0;
    if(actor->id==0) {
        if(actor->x<6*8) return 1;
    } else {
        if(actor->x>28*8) return 1;
    }
    return 0;
}

/* Droping what is in the left hand */
void drop_hand(Bunny *actor,int hand)
{
    int i;
    if(actor->hold[hand]==0) return;
    if(on_basket(actor)) {
        for(i=0;i<4;i++) {
            if(actor->need[i]==actor->hold[hand]) {
                actor->need[i]=0;
                break;
            }
        }
        if(i==4) return;         /* Didn't need it in the basket */
        for(i=0;i<4;i++) {
            if(actor->has[i]==0) {
                actor->has[i]=actor->hold[hand];
                actor->hold[hand]=0;
                break;
            }
        }
    } else {
        put_char(actor->x/8,actor->y/8,actor->hold[hand]);
        actor->hold[hand]=0;
    }
    for(i=0;i<4;i++) {
        if(actor->need[i]!=0) return;
    }
    /* Met the win conditions */
    level_active=0;
}

/* state 5 : standing at the basket - simple AI Bunny droping ingredients */
void standing_at_basket(Bunny *actor)
{
    if(actor->hold[0]!=0) {
        drop_hand(actor,0);
    }
    if(actor->hold[1]!=0) {
        drop_hand(actor,1);
    }
    actor->state=1;
}

unsigned calcdistance(unsigned x1, unsigned y1, unsigned x2, unsigned y2)
{
     unsigned deltax = absdiff(x1,x2);
     unsigned deltay = absdiff(y1,y2);

     return (deltax+deltay); 
}

/* state 1 : seeking ingredients */
void seek_ingredient(Bunny *actor)
{
    byte i,x,y,count;	/* counters, the number of ingredients */
    char want[4];
    char closest=0;
    byte closestx=0,closesty=0;
    unsigned closestdist = 4096;
    unsigned dist;
    char line[32];

    /* Checking what needed to build a wanted list */    
    for(i=0,count=0;i<4;i++) {
        char n=actor->need[i];
        if(n!=0 && n!=actor->hold[0] && n!=actor->hold[1]) {
            want[count++]=n;
        }
    }
    if(count==0) return;
    
    /* Scanning the screen for wanted ingredients */
    for(y=6;y<24;y++) {
        get_bkgrnd(line,0,y,32,1);
        for(x=2;x<32;x++) {
            char c=line[x];
            for(i=0;i<count;i++) {
                if(c==want[i]) {
                    dist=calcdistance(actor->x/8,actor->y/8,x,y);
                    if(dist<=closestdist) {
                        closestx=x; closesty=y; closest=c; closestdist=dist;
                    }
                }
            }
        }
    }
    
    /* no wanted ingredient found, then do nothing */
    if(closest==0) {
        return;	/* Stay in state 1 */
    }
    
    /* otherwise, go for it */
    actor->target=closest;
    actor->targetx=closestx*8;
    actor->targety=closesty*8;
    actor->state=2;
}

void dispatch_bunny(Bunny *actor)
{
     refresh_status(actor);

     switch(actor->state) {
     case 1:
          seek_ingredient(actor);
          break;
     case 2:
     case 4:
          walk_towards(actor);
          break;
     case 3:
          standing_at_ingredient(actor);
          break;
     case 5:
          standing_at_basket(actor);
          break;
     default:
          actor->state=1;
     }     
}

int is_vegetable(char c)
{
    byte i;
    for (i=1;i<sizeof(ingredient_name)/sizeof(struct IngredInfo);i++)
    {
        if(c==ingredient_name[i].ch) return 1;
    }
    return 0;
}

void handle_fire(Bunny *actor,int hand)
{
     byte c;
     
     c = (byte)get_char(actor->x/8,actor->y/8);
     
     if (c==0x80 || c==0x81 || on_basket(actor)!=0 )
     {
          /* GRASS OR BASKET */
          
          drop_hand(actor,hand);
          shoot();
     } else {
          char drop=actor->hold[hand];
          if(drop==0) drop=0x8c;
          if( is_vegetable(c)) {
              /* Something to pick up */
              actor->hold[hand]=c;
              put_char(actor->x/8,actor->y/8,drop);
              pop();
          }
     }
     refresh_status(actor);
}                 

byte oldjoy[2];

void update_bunny(Bunny *actor)
{
    if(actor->delay>0) {
        actor->delay--;
        return;
    }
    actor->delay=4-game_speed;

    /* At the beginning of a hop cycle? */
    if((actor->frame&3)==0) {
        /* Time for a potiental new direction */
        if (actor->isNPC)
        {
            /* Go to Bunny AI function */
            dispatch_bunny(actor);
        } else {
            /* JOYSTICK INPUT */
            byte joy;
            byte oj=oldjoy[actor->id];
            if (actor->id==0) {
                joy = joypad_1;
            } else {
                joy = joypad_2;
            }
            /* center_string(6,str(joy)); */
            
            actor->dir = joy & 15;
            
            if (joy&FIRE1 && (oj&FIRE1)==0)
            {
                 handle_fire(actor,0);
            } 
            if (joy&FIRE2 && (oj&FIRE2)==0)
            {
                handle_fire(actor,1);
            } 
            oldjoy[actor->id]=joy;
        }
        set_bunny_dir(actor);
    }
    
    sprites[actor->id].y=actor->y;
	sprites[actor->id].x=actor->x;
	sprites[actor->id].pattern=actor->frame*4;
	sprites[actor->id].colour=15-2*actor->id;

	if(actor->dir!=0) {
	    actor->frame=(actor->frame&~3)+((actor->frame+1)&3);
	    if((actor->frame&3)==3 || (actor->frame&3)==0) {
	        move_bunny(actor);
	    }    
	}     
}


void game_engine()
{
    theme(level);
    while (level_active)
    {
		/* Calculate the new sprite pos */
		/* Bunny #1 */
		update_bunny(&bunny[0]);
		/* Bunny #2 */
		update_bunny(&bunny[1]);
		/* Delay */
        game_delay();
		/* Show all of the sprites */
		updatesprites(0,11);
    }
    sprites[0].y=207;
    sprites[1].y=207;
    updatesprites(0,11);
}

void game_over()
{
    unsigned score=0;
    cls();
    center_string(6,"GAME  OVER");
    center_string(10,"Player 1");
    center_string(11,str(bunny[0].score));
    if(score<bunny[0].score) score=bunny[0].score;
    center_string(13,"Player 2");
    center_string(14,str(bunny[1].score));
    if(score<bunny[1].score) score=bunny[1].score;
    if (score>hiscore)
    {
        center_string(16,"OLD HI-SCORE");
        center_string(17,str(hiscore));
        hiscore=score;
    }
    else
    {
        center_string(16,"HI-SCORE");
        center_string(17,str(hiscore));
    }        
    enable_nmi();
    pause();
    disable_nmi();
}

#define INGREDCOUNT (sizeof(ingredient_name)/sizeof(struct IngredInfo))
void menu()
{
    char choice; 
    char x,y;
    cls();
    for(x=7;x<26;x++) {
       put_char(x,0,ingredient_name[1+x%(INGREDCOUNT-1)].ch);
       put_char(x,9,ingredient_name[1+x%(INGREDCOUNT-1)].ch);
    }
    for(y=1;y<9;y++) {
       put_char(7,y,ingredient_name[1+y%(INGREDCOUNT-1)].ch);
       put_char(25,y,ingredient_name[1+y%(INGREDCOUNT-1)].ch);
    }
    
    center_string(2,"Warm Fuzzy:");
    center_string(3,"Quest for Salad");
    center_string(6,"By Dale Wick");
    center_string(7,"2005");
    center_string(11,"Select Game Speed");
    center_string(12,"(1=Fast,4=Slow)");
    enable_nmi();    
    game_speed=choice_keypad_1(1,4);
    disable_nmi();
    center_string(16,"5 = Player vs Player");
    center_string(17,"6 = Player vs Coleco");
    center_string(18,"7 = Coleco vs Player");
    center_string(19,"8 = Coleco vs Coleco");
    enable_nmi();    
    choice=choice_keypad_1(5,8)-5;
    disable_nmi();
    if (choice&1) bunny[1].isNPC = 1; else bunny[1].isNPC = 0;
    if (choice&2) bunny[0].isNPC = 1; else bunny[0].isNPC = 0;
}

void show_intro_screen(char level)
{
     char i;
     
     cls();
     
     center_string(5,"Get Ready Chefs");
     center_string(7,"RECIPE  ");
     put_char(19,7,'1'+level);
     center_string(8,salad[level].name);
     
     for(i=0;i<4;i++) {
         int y=10+i*2;
         enum Ingred ingred=salad[level].ingredient[i].ingred;
         int score=salad[level].ingredient[i].points;
         char ch=ingredient_name[ingred].ch;
         put_char(8,y,ch);
         put_char(10,y,score+'0');
         print_at(12,y,
           score>1?ingredient_name[ingred].plural:
           ingredient_name[ingred].singular);
     }
     
     enable_nmi();
     delay(300);
     disable_nmi();
}

enum Ingred to_ingred(char ch)
{
    byte i;
    for (i=1;i<sizeof(ingredient_name)/sizeof(struct IngredInfo);i++)
    {
        if(ch==ingredient_name[i].ch) return (enum Ingred)i;
    }
    return (enum Ingred)0;
}

int get_points(char level,enum Ingred ingred)
{
    int i;
    
    for(i=0;i<4;i++) {
        if(salad[level].ingredient[i].ingred==ingred)
            return salad[level].ingredient[i].points;
    }
    return 0;
}
    
void print_wrap(char x,char y,char width,char *s)
{
     char line[17];  /* Max width */
     int len=strlen(s);
     while(len>0) {
         int p;
         if(len<=width) {
             print_at(x,y,s);
             break;
         }
         for(p=width-1;p>0;p--) {
             if(s[p]==' ') break;
         }
         if(p==0) p=width; /* No break */
         strncpy(line,s,p);
         line[p]=0;
         print_at(x,y,line);
         s+=p+1;
         len=strlen(s);
         y++;
     }
}
    
void show_score_screen(char level)
{
     int i;
     
     cls();
     center_string(8,"RECIPE COMPLETE");
     
     print_at(2,10,"Player 1");
     print_at(16,10,"Player 2");
     for(i=0;i<4;i++) {
        int y=12+i*2;
        char ch;
        ch=bunny[0].has[i];
        if(ch!=0) {
            enum Ingred ingred=to_ingred(ch);
            put_char(2,y,ch);
            print_wrap(4,y,10,ingredient_name[ingred].singular);
            bunny[0].score+=get_points(level,ingred);
        }
        ch=bunny[1].has[i];
        if(ch!=0) {
            enum Ingred ingred=to_ingred(ch);
            put_char(16,y,ch);
            put_char(17,y,' ');
            print_wrap(18,y,13,ingredient_name[ingred].singular);
            bunny[1].score+=get_points(level,ingred);
        }
     }
     
     enable_nmi();
     delay(300);
     disable_nmi();
}
    
/* main function */
void main()
{
    int i;
    init_graphics(); /* init. graphics */
    hiscore=0; /* reset hiscore */
    theme(0);  /* debug for writing music */
restart:
    menu(); /* show menu */
    bunny[0].score=0;
    bunny[1].score=0;
    for(i=0;i<sizeof(salad)/sizeof(Salad);i++) {
        show_intro_screen(i);
        initialize_level(i); /* initialize game variables */
        game_engine(); /* play game */
        show_score_screen(i);
    }
    game_over(); /* print "game over" */
    goto restart;
}

/* nmi function */
void nmi()
{
    update_sound();
}
