#include <stdio.h>

#define MEM 64*1024


unsigned char mem[MEM], set[MEM];


#define HEXVAL(c)	(('0' <= (c) && (c) <= '9') ? (c) - '0' :\
					(('a' <= (c) && (c) <= 'f') ? (c) - 'a' + 10 :\
					(('A' <= (c) && (c) <= 'F') ? (c) - 'A' + 10 :\
					-1 )))

int gethex(fp)
FILE *fp;
{
	int i, j;

	i = getc(fp);
	j = getc(fp);
	if (i < 0 || j < 0)
		return -1;
	i = HEXVAL(i);
	j = HEXVAL(j);
	if (i < 0 || j < 0)
		return -1;
	return (i << 4) | j;
}


void loadhex(fp)
FILE *fp;
{
	int len, line;
	unsigned short addr, check, t;

	for (line = 1; getc(fp) >= 0; line++)		/* should be a ':' */
	{
		if ((len = gethex(fp)) <= 0)
			break;
		check = len;
		if ((addr = gethex(fp)) < 0)
			break;
		check += addr;
		if ((t = gethex(fp)) < 0)
			break;
		check += t;
		addr = (addr << 8) | t;
		if ((t = gethex(fp)) < 0)		/* ??? */
			break;
		check += t;
		while (len-- > 0)
		{
			if ((t = gethex(fp)) < 0)
				break;
			check += t;
			set[addr] = 1;
			mem[addr++] = t;
		}
		if ((t = gethex(fp)) < 0)		/* checksum */
			break;
		if (((256 - t) & 0xFF) != (check & 0xFF))
		{
			fprintf(stderr, "%d: Checksum error: %.2X != %.2X!\r\n",
					line, (256 - t) & 0xFF, check & 0xFF);
			return;
		}
		if (getc(fp) < 0)		/* should be a '\n' */
			break;
	}
}


main()
{
	int i, start, end;

	loadhex(stdin);
	for (start = 0; start < MEM; start++)
		if (set[start])
			break;
	for (end = MEM - 1; end >= 0; end--)
		if (set[end])
			break;
	for (i = start; i <= end; i++)
		putchar(mem[i]);
}
